package gui;

import java.awt.EventQueue;
import java.awt.Frame;

import javax.swing.JDialog;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import net.miginfocom.swing.MigLayout;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.JLabel;
import javax.swing.JTextField;

import music.Song;

import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class NewDialog extends JDialog {
	private JPanel centerPanel;
	private JPanel southPanel;
	private JButton btnOk;
	private JButton btnCancel;
	private JTabbedPane tabbedPane;
	private JPanel songPanel;
	private JPanel authorPanel;
	private JLabel lblTitle;
	private JLabel lblYear;
	private JLabel lblLyrics;
	private JTextField titleTextField;
	private JTextField yearTextField;
	private JScrollPane lyricsScrollPane;
	private JTextArea lyricsTextArea;
	
	private Song song;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					NewDialog dialog = new NewDialog();
					dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					dialog.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	public NewDialog(Frame owner, boolean modal) {
		super(owner, modal);
		setTitle("New");
		setBounds(100, 100, 450, 300);
		getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
	}

	/**
	 * Create the dialog.
	 */
	public NewDialog() {
		setTitle("New");
		setBounds(100, 100, 450, 300);
		getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);

	}
	
	public Song showDialog() {
		setVisible(true);
		dispose();
		return song;
	}

	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centerPanel.add(getTabbedPane(), "cell 0 0,grow");
		}
		return centerPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][]", "[]"));
			southPanel.add(getBtnOk(), "cell 1 0");
			southPanel.add(getBtnCancel(), "cell 2 0");
		}
		return southPanel;
	}
	private JButton getBtnOk() {
		if (btnOk == null) {
			btnOk = new JButton("OK");
			btnOk.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
//					song = new Song();
					setVisible(false);
					song = null;
				}
			});
		}
		return btnOk;
	}
	private JButton getBtnCancel() {
		if (btnCancel == null) {
			btnCancel = new JButton("Cancel");
			btnCancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
                    setVisible(false);
					song = null;
				}
			});
		}
		return btnCancel;
	}
	private JTabbedPane getTabbedPane() {
		if (tabbedPane == null) {
			tabbedPane = new JTabbedPane(JTabbedPane.TOP);
			tabbedPane.addTab("Song", null, getSongPanel(), null);
			tabbedPane.addTab("Author", null, getAuthorPanel(), null);
		}
		return tabbedPane;
	}
	private JPanel getSongPanel() {
		if (songPanel == null) {
			songPanel = new JPanel();
			songPanel.setLayout(new MigLayout("", "[][grow]", "[][][][grow]"));
			songPanel.add(getLblTitle(), "cell 0 0,alignx left");
			songPanel.add(getTitleTextField(), "cell 1 0,growx");
			songPanel.add(getLblYear(), "cell 0 1,alignx left");
			songPanel.add(getYearTextField(), "cell 1 1,growx");
			songPanel.add(getLblLyrics(), "cell 0 2");
			songPanel.add(getLyricsScrollPane(), "cell 0 3 2 1,grow");
		}
		return songPanel;
	}
	private JPanel getAuthorPanel() {
		if (authorPanel == null) {
			authorPanel = new JPanel();
			authorPanel.setLayout(new MigLayout("", "[]", "[]"));
		}
		return authorPanel;
	}
	private JLabel getLblTitle() {
		if (lblTitle == null) {
			lblTitle = new JLabel("Title");
		}
		return lblTitle;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JLabel getLblLyrics() {
		if (lblLyrics == null) {
			lblLyrics = new JLabel("Lyrics");
		}
		return lblLyrics;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JTextField getYearTextField() {
		if (yearTextField == null) {
			yearTextField = new JTextField();
			yearTextField.setColumns(10);
		}
		return yearTextField;
	}
	private JScrollPane getLyricsScrollPane() {
		if (lyricsScrollPane == null) {
			lyricsScrollPane = new JScrollPane();
			lyricsScrollPane.setViewportView(getTextArea_1());
		}
		return lyricsScrollPane;
	}
	private JTextArea getTextArea_1() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		return lyricsTextArea;
	}
}
